<?php

namespace Inspire_Labs\Empik_Woocommerce\Wp_Admin\CSV;

use Inspire_Labs\Empik_Woocommerce\Api_Client\Api_Factory;use Inspire_Labs\Empik_Woocommerce\Plugin;

/**
 * Settings for CSV importer
 * @version 0.1
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CSV_Settings{

    private $log;

	function __construct() {
		echo $this->content();
		$this->log = array();
	}
	function content() {
		// Settings Tabs
		$tabs = array(
			'empik_csv_1'=> esc_html__('Bulk change of logistics class', 'empik-for-woocommerce'),
			'empik_csv_2'=> esc_html__('Bulk change of product states', 'empik-for-woocommerce'),
		);

		$focus_tab = ( isset( $_GET['tab'] ) )
			? urldecode( sanitize_text_field( $_GET['tab'] ) )
			: 'empik_csv_1';

		?>
		<div class="wrap" id='empik_csv_settings'>
			<div id='eventon'>
			    <div id="icon-themes" class="icon32"></div>
			</div>
			<h1><?php esc_html_e('Settings for bulk update', 'empik-for-woocommerce' );?></h1>
			<h2 class='nav-tab-wrapper' id='meta_tabs'>
				<?php
					foreach( $tabs as $nt => $ntv ) {
						echo "<a href='?page=ilabs_empik&tab="
						. esc_attr( $nt ) . "' class='nav-tab "
						. ( ($focus_tab == $nt) ? 'nav-tab-active' : null)
						. "' evo_meta='". esc_attr( $nt ) ."'>" . esc_attr( $ntv ) . "</a>";
					}
				?>
			</h2>
		<div class='metabox-holder'>
		<?php
		if( isset( $_POST['settings-updated'] ) ) {
		    echo sprintf(
                   '<div class="updated fade"><p>%s</p></div>',
                   esc_html( sanitize_text_field( $_POST['settings-updated'] ) )
             );
		}

		//TABS
		switch ( $focus_tab ):
		    // Import step
			case "empik_csv_1":
				echo "<div id='empik_csv_1' class='postbox'><div class='inside'>";
				$steps = ( !isset( $_GET['steps']) ) ? 'start' : sanitize_text_field( $_GET['steps'] );
				echo $this->import_logistic_class( $steps );
				echo "</div></div>";
			break;
			case "empik_csv_2":
				echo "<div id='empik_csv_2' class='postbox'><div class='inside'>";
				$steps = ( !isset( $_GET['steps']) ) ? 'start' : sanitize_text_field( $_GET['steps'] );
				echo $this->import_product_state( $steps );
				echo "</div></div>";
			break;
		endswitch;
		echo "</div>";
	}

	// import
    function import_logistic_class($step){

        switch ($step) {
            // reading file and showing results
            case 'table':
                $this->display_events();
            break;
            case 'start':
                ob_start();
                echo "<h2>" . esc_html__( 'Select a CSV file', 'empik-for-woocommerce') . "</h2>";
                echo "<p>" . esc_html__('File must contains at least 2 obligatory columns:', 'empik-for-woocommerce') . "</p>";
                echo "<p><b>ID</b></p>";
                echo "<p><b>" . esc_html__( 'logistic-class', 'empik-for-woocommerce') . "</b></p>";
                echo "<form action='" . esc_url( admin_url() ) . "admin.php?page=ilabs_empik&tab=empik_csv_1&steps=table' method='post' enctype='multipart/form-data'>";

                    settings_fields('empik_csv_field_grp');
                    wp_nonce_field( 'empik-for-woocommerce', 'empik_csv_noncename' );

                echo "<input id='events_csv_file' type='file' name='events_csv_file'/><br/><br/>";
                echo "<input id='test_csv' type='submit' name='' class='button-primary btn_prime evo_admin_btn' value=" . esc_html__( 'Upload CSV file', 'empik-for-woocommerce') . "/>";
                echo "</form>";
                echo ob_get_clean();
            break;
        }

    }


    function import_product_state($step){

        switch ($step) {
            // reading file and showing results
            case 'table':
                $this->display_product_states();
            break;
            case 'start':
                $api_factory    = new Api_Factory();
                $api            = $api_factory->create_service();
                $product_states = $api->of61_get_product_states();
                ob_start();
                echo "<div class='container'>";
                echo "<div class='empik_row' style='display: grid;grid-template-columns: 1fr 2fr;grid-auto-rows: minmax(64px,auto);column-gap: 16px;'>";
                echo "<div class='empik_desc_section'>";
                echo "<h2>" . esc_html__( 'Select a CSV file', 'empik-for-woocommerce') . "</h2>";
                echo "<p>" . esc_html__('File must contains at least 2 obligatory columns:', 'empik-for-woocommerce') . "</p>";
                echo "<p><b>" . esc_html__( 'ID', 'empik-for-woocommerce') . "</b></p>";
                echo "<p><b>" . esc_html__( 'state', 'empik-for-woocommerce') . "</b></p>";
                echo "</div>";
                echo "<div class='empik_desc_section'>";
                echo "<br>";
                echo "<p>ID - " . esc_html__('add product ID', 'empik-for-woocommerce') . "</p>";
                echo "<p>state - " . esc_html__('add code for one of these values:', 'empik-for-woocommerce') . "</p>";
                echo "<br>";
                if( ! empty($product_states) && is_array($product_states) ) {
	                foreach($product_states as $key => $state) {
	                    echo "<p class='empik-state-desc' style='line-height: 0.8;'>" . esc_attr( $state ) . " (kod=" . esc_attr( $key ) . ")" . "</p>";
	                }
                }
                echo "</div>";
                echo "<form action='" . esc_url( admin_url() ) ."admin.php?page=ilabs_empik&tab=empik_csv_2&steps=table' method='post' enctype='multipart/form-data'>";

                    settings_fields('empik_csv_field_grp');
                    wp_nonce_field( 'empik-for-woocommerce', 'empik_csv_noncename' );

                echo "<input id='events_csv_file' type='file' name='events_csv_file'/><br/><br/>";
                echo "<input id='test_csv' type='submit' name='' class='button-primary btn_prime evo_admin_btn' value=" . esc_html__( 'Upload CSV file', 'empik-for-woocommerce') . "/>";
                echo "</form>";
                echo ob_get_clean();
            break;
        }

    }

	// display fetched events list
    function display_events(){

        if( !$this->csv_verify_nonce_post( 'empik_csv_noncename')) {
            echo "<a href='?page=ilabs_empik&tab=empik_csv_1'>"
                . esc_html__( "Return", 'empik-for-woocommerce' ) .
                    "</a>";
            return false;
        }


        // verified nonce
        if (empty($_FILES['events_csv_file']['tmp_name'])) {
            $this->log['error'][] = esc_html__( 'No file uploaded, please try again.', 'empik-for-woocommerce' );

            $this->print_messages();
            $this->import_logistic_class('start');
            return;
        }

        $file = $_FILES['events_csv_file']['tmp_name'];
        $csv_array = $this->check_csv_delimeter($file);
        $COUNT = count( $csv_array );

        echo "<h2>" . esc_html__( 'Verify processed import', 'empik-for-woocommerce' ) . "</h2>";
        echo "<p>" . esc_html__( 'Select the rows you want to import.', 'empik-for-woocommerce' )
        . '<br/>' . esc_html__( 'Processed ', 'empik-for-woocommerce' ) . '<b>' . esc_attr( $COUNT ). '</b>' . esc_html__( ' items total.', 'empik-for-woocommerce' ) . "</p>";

        // if no items present on processed
        if( $COUNT==0 )
            echo "<p style='padding:4px 10px; background-color:#F9E5E1'>"
            . esc_html__( 'Check CSV file. Some error is occurred.', 'empik-for-woocommerce' ) . "</p>";

        if( $COUNT==0 ) return false;

        echo "<form id='emp_log_classes' class='evocsv_import_form' action='" . esc_url( admin_url() ) . "admin.php?page=evocsv&steps=sun' method='post' enctype='multipart/form-data'>

            <p id='select_row_options'>
                <a class='button deselect btn_triad evo_admin_btn'>
                    <span></span>"
                    . esc_html__( 'Deselect All', 'empik-for-woocommerce' ) .
                "</a> 
                <a class='button select btn_triad evo_admin_btn'>
                    <span></span>"
                    . esc_html__( 'Select All', 'empik-for-woocommerce' ) .
                    "</a> 
                <input id='evocsv_import_selected' style='display:none; float:right' type='submit' class='btn_prime evo_admin_btn' value='" . esc_html__( 'Import selected', 'empik-for-woocommerce' ) . "'/>
                <a id='evocsv_import_selected_items' class='button-primary btn_prime evo_admin_btn'>
                <span></span>"
                . esc_html__( 'Import', 'empik-for-woocommerce' ) .
                "</a>
            </p>

            <div id='evocsv_import_progress' style='display:none'>
                <p class='bar'><span></span></p>
                <p class='text'><em id='success_count'>0</em>" . esc_html__( ' out of ', 'empik-for-woocommerce' ) . "<i>" . esc_attr( $COUNT ) . "</i>" . esc_html__( ' proccessed.', 'empik-for-woocommerce' ) . " 
                <b class='loading'></b>
                <span class='failed' style='display:none'><em id='failed_count'></em>" . esc_html__( ' Failed', 'empik-for-woocommerce' ) . "</span>
                </p>					
            </div>

            <div id='evocsv_import_results' style='display:none'>
                <p class='results'><b></b>"
                    . esc_html__( 'Import', 'empik-for-woocommerce' ) .
                    "<span class='good'><em>1</em>" . esc_html__( ' Imported', 'empik-for-woocommerce' ) . "</span> 
                    <span class='bad'><em>0</em>" . esc_html__( ' Failed', 'empik-for-woocommerce' ) . "</span>
                </p>
                <p style='display:none'><a href='".admin_url()."'>" . esc_html__( ' View all imported', 'empik-for-woocommerce' ) . "</a></p>
            </div>

            <p id='evocsv_import_errors' style='display:none'>" . esc_html__( 'Error', 'empik-for-woocommerce' ) . "</p>
        

            <div id='evocsv_fetched_events'>";
            settings_fields('empik_csv_field_grp');
            wp_nonce_field( 'empik-for-woocommerce', 'empik_csv_noncename' );

        echo "<table id='evocsv_events' class='wp-list-table widefat'>
            <thead><tr>
                <th>".esc_html__('Status', 'empik-for-woocommerce')."</th>
                <th>".esc_html__('ID', 'empik-for-woocommerce')."</th>
                <th>".esc_html__('SKU', 'empik-for-woocommerce')."</th>
                <th>".esc_html__('Name', 'empik-for-woocommerce')."</th>
                <th>".esc_html__('Logistic class', 'empik-for-woocommerce')."</th>                
                </tr>
            </thead><tbody>";

        $count = 1;

        foreach( $csv_array as $csv_data) {

            $column_title_with_logistic_class = false;

            if( isset($csv_data['logistic-class']) ) {
                $column_title_with_logistic_class = $csv_data['logistic-class'];
            } else if( isset($csv_data['Logistic-class']) ) {
                $column_title_with_logistic_class = $csv_data['Logistic-class'];
            }

            $logistic_klass = '';
            if( $column_title_with_logistic_class ) {
                if( $column_title_with_logistic_class === '0') {
                    $logistic_klass = '0';
                } else {
                    $logistic_klass = ! empty( $column_title_with_logistic_class ) ? $column_title_with_logistic_class : '2';
                }
            } else {
                $logistic_klass = '2';
            }

            echo "<tr class='row' data-status='ss'><td>";

            $this->hidden_fields( $csv_data, $count );

            $product_name_field = false;
            if( isset($csv_data['Name']) ) {
                $product_name_field = $csv_data['Name'];
            } else if( isset($csv_data['Nazwa']) ) {
                $product_name_field = $csv_data['Nazwa'];
            }

            echo "<span class='status ss' title='Selected'></span></td>";
            echo "<td><span>" . ( !empty( $csv_data['ID'] ) ? esc_html( $csv_data['ID'] ) : '') ."</span></td>";
            echo "<td><span>" . ( !empty( $csv_data['SKU'] ) ? esc_html( $csv_data['SKU'] ) : '') ."</span></td>";
            echo "<td><span>" . ( $product_name_field ? esc_html( $product_name_field ) : '') ."</span></td>";
            echo "<td><span>". esc_html( $logistic_klass ) ."</span></td>";

            echo "</tr>";

            $count ++;
        }

        echo "</tbody></table></div>";

        echo "</form>";
    }



    function display_product_states(){

        if( !$this->csv_verify_nonce_post( 'empik_csv_noncename')) {
            echo "<a href='?page=ilabs_empik&tab=empik_csv_2'>"
                . esc_html__( "Return", 'empik-for-woocommerce' ) .
                    "</a>";
            return false;
        }


        // verified nonce
        if (empty($_FILES['events_csv_file']['tmp_name'])) {
            $this->log['error'][] = esc_html__( 'No file uploaded, please try again.', 'empik-for-woocommerce' );

            $this->print_messages();
            $this->import_product_state('start');
            return;
        }

        $file = $_FILES['events_csv_file']['tmp_name'];
        $csv_array = $this->check_csv_delimeter($file);
        $COUNT = count( $csv_array );

        echo "<h2>" . esc_html__( 'Verify processed import', 'empik-for-woocommerce' ) . "</h2>";
        echo "<p>" . esc_html__( 'Select the rows you want to import.', 'empik-for-woocommerce' )
        . '<br/>' . esc_html__( 'Processed ', 'empik-for-woocommerce' ) . '<b>' . esc_attr( $COUNT ) . '</b>' . esc_html__( ' items total.', 'empik-for-woocommerce' ) . "</p>";

        // if no items present on processed
        if( $COUNT==0 )
            echo "<p style='padding:4px 10px; background-color:#F9E5E1'>"
            . esc_html__( 'Check CSV file. Some error is occurred.', 'empik-for-woocommerce' ) . "</p>";

        if( $COUNT==0 ) return false;

        echo "<form id='emp_prod_states' class='evocsv_import_form' action='" . esc_url( admin_url() ) . "admin.php?page=evocsv&steps=sun' method='post' enctype='multipart/form-data'>

            <p id='select_row_options'>
                <a class='button deselect btn_triad evo_admin_btn'>
                    <span></span>"
                    . esc_html__( 'Deselect All', 'empik-for-woocommerce' ) .
                "</a> 
                <a class='button select btn_triad evo_admin_btn'>
                    <span></span>"
                    . esc_html__( 'Select All', 'empik-for-woocommerce' ) .
                    "</a> 
                <input id='evocsv_import_selected' style='display:none; float:right' type='submit' class='btn_prime evo_admin_btn' value='" . esc_html__( 'Import selected', 'empik-for-woocommerce' ) . "'/>
                <a id='evocsv_import_selected_items' class='button-primary btn_prime evo_admin_btn'>
                <span></span>"
                . esc_html__( 'Import', 'empik-for-woocommerce' ) .
                "</a>
            </p>

            <div id='evocsv_import_progress' style='display:none'>
                <p class='bar'><span></span></p>
                <p class='text'><em id='success_count'>0</em>" . esc_html__( ' out of ', 'empik-for-woocommerce' ) . "<i>" . esc_attr( $COUNT ) . "</i>" . esc_html__( ' proccessed.', 'empik-for-woocommerce' ) . " 
                <b class='loading'></b>
                <span class='failed' style='display:none'><em id='failed_count'></em>" . esc_html__( ' Failed', 'empik-for-woocommerce' ) . "</span>
                </p>					
            </div>

            <div id='evocsv_import_results' style='display:none'>
                <p class='results'><b></b>"
                    . esc_html__( 'Import', 'empik-for-woocommerce' ) .
                    "<span class='good'><em>1</em>" . esc_html__( ' Imported', 'empik-for-woocommerce' ) . "</span> 
                    <span class='bad'><em>0</em>" . esc_html__( ' Failed', 'empik-for-woocommerce' ) . "</span>
                </p>
                <p style='display:none'><a href='".admin_url()."'>View all imported...</a></p>
            </div>

            <p id='evocsv_import_errors' style='display:none'>" . esc_html__( 'Error', 'empik-for-woocommerce' ) . "</p>
        

            <div id='evocsv_fetched_events'>";
            settings_fields('empik_csv_field_grp');
            wp_nonce_field( 'empik-for-woocommerce', 'empik_csv_noncename' );

        echo "<table id='evocsv_events' class='wp-list-table widefat'>
            <thead><tr>
                <th>".esc_html__('Status', 'empik-for-woocommerce')."</th>
                <th>".esc_html__('ID', 'empik-for-woocommerce')."</th>
                <th>".esc_html__('SKU', 'empik-for-woocommerce')."</th>
                <th>".esc_html__('Name', 'empik-for-woocommerce')."</th>
                <th>".esc_html__('State', 'empik-for-woocommerce')."</th>                
                </tr>
            </thead><tbody>";

        $count = 1;

        foreach( $csv_array as $csv_data) {

            $column_title_with_state = false;

            if( isset($csv_data['state']) ) {
                $column_title_with_state = $csv_data['state'];
            } else if( isset($csv_data['State']) ) {
                $column_title_with_state = $csv_data['State'];
            }

            $state = '';
            if( $column_title_with_state ) {
                $state = $column_title_with_state;
            }

            echo "<tr class='row' data-status='ss'><td>";

            $this->hidden_fields( $csv_data, $count );

            $product_name_field = false;
            if( isset($csv_data['Name']) ) {
                $product_name_field = $csv_data['Name'];
            } else if( isset($csv_data['Nazwa']) ) {
                $product_name_field = $csv_data['Nazwa'];
            }

            echo "<span class='status ss' title='Selected'></span></td>";
            echo "<td><span>" . ( !empty( $csv_data['ID'] ) ? esc_html( $csv_data['ID'] ) : '') ."</span></td>";
            echo "<td><span>" . ( !empty( $csv_data['SKU'] ) ? esc_html( $csv_data['SKU'] ) : '') ."</span></td>";
            echo "<td><span>" . ( $product_name_field ? esc_html( $product_name_field ) : '') ."</span></td>";
            echo "<td><span>". esc_html( $state ) ."</span></td>";

            echo "</tr>";

            $count ++;
        }

        echo "</tbody></table></div>";

        echo "</form>";
    }


    // throw input and textfields hidden fields
    function hidden_fields($csv_data, $count) {

        ?><input class='input_status' type='hidden' name='events[<?php echo esc_attr( $count );?>][status]' value='ss'/>
        <?php

        $fields = [];

        if( isset($_GET['tab']) && 'empik_csv_2' === sanitize_text_field( $_GET['tab'] ) ) {
            $fields = $this->get_all_fields_state();
        } elseif ( isset($_GET['tab']) && 'empik_csv_1' === sanitize_text_field( $_GET['tab'] ) ) {
            $fields = $this->get_all_fields();
        }

        if( !is_array( $fields ) ) return;

        foreach( $fields as $field ){
            if( empty( $csv_data[$field]) ) continue;
            echo "<input class='evocsv_event_data_row' type='hidden' name='events[" . esc_attr($count) . "][" . esc_attr($field) . "]' ". 'value="'. addslashes(esc_html($csv_data[$field])) .'"/>';
        }
    }

    /** function to verify wp nonce */
    function csv_verify_nonce_post( $post_field ) {

        if( isset( $_POST[$post_field] ) && ! empty( $_POST[$post_field] ) ) {
            if ( wp_verify_nonce( sanitize_text_field( wp_unslash ( $_POST[$post_field] ) ) , 'empik-for-woocommerce' ) ) {
                return true;
            } else {
                $this->log['error'][] = esc_html__( 'Could not verify submission. Please try again.', 'empik-for-woocommerce' );
                $this->print_messages();
                return false;	}
        } else {
            $this->log['error'][] = esc_html__( 'Please start from uploading file.', 'empik-for-woocommerce' );
            $this->print_messages();
            return false;
        }
    }

    /** Print the messages for the csv settings	 */
    function print_messages(){
        if (!empty($this->log)) {

            if (!empty($this->log['error'])): ?>
            <div class="error">
                <?php foreach ($this->log['error'] as $error): ?>
                    <p class=''><?php echo esc_html( $error ); ?></p>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>

            <?php if (!empty($this->log['notice'])): ?>
            <div class="updated fade">
                <?php foreach ($this->log['notice'] as $notice): ?>
                    <p><?php echo esc_html( $notice ); ?></p>
                <?php endforeach; ?>
            </div>
            <?php endif;

            $this->log = array();
        }
    }

    // CSV file stripping
    function stripBOM( $fname ) {
        $res = fopen($fname, 'rb');
        if (false !== $res) {
            $bytes = fread($res, 3);
            if ($bytes == pack('CCC', 0xef, 0xbb, 0xbf)) {
                $this->log['notice'][] = 'Getting rid of byte order mark...';
                fclose($res);

                $contents = file_get_contents($fname);
                if (false === $contents) {
                    trigger_error('Failed to get file contents.', E_USER_WARNING);
                }
                $contents = substr($contents, 3);
                $success = file_put_contents($fname, $contents);
                if (false === $success) {
                    trigger_error('Failed to put file contents.', E_USER_WARNING);
                }
            } else {
                fclose($res);
            }
        } else {
            $this->log['error'][] = 'Failed to open file, aborting.';
        }
    }


    private function get_all_fields(){
		$fields =  array(
			0 => 'ID',
			'publish_status',
			'SKU',
			'Name',
			'Nazwa',
			'logistic-class',
			'Logistic-class'
		);
		return $fields;
	}


	private function get_all_fields_state(){
		$fields =  array(
			0 => 'ID',
			'publish_status',
			'SKU',
			'Name',
			'Nazwa',
			'state',
			'State'
		);
		return $fields;
	}


	private function check_csv_delimeter($file) {
        // load uploaded file content

        $csv = new File_CSV_DataSource();

        $this->stripBOM($file);

        // check if file loaded correct
        if ( ! $csv->load( $file ) ) {
            $this->log['error'][] = esc_html__( 'Failed to load file, please try again.',  'empik-for-woocommerce' );
            $this->print_messages();
            $this->import_logistic_class('start');
            return;
        }

        $csv->symmetrize();

        // if separator another then comma - override settings
        if (! isset($csv->connect()[0]['ID'])) {
            $csv = new File_CSV_DataSource();
            $csv->settings['delimiter'] = ';';

            // check if file loaded correct
            if (!$csv->load($file)) {
                $this->log['error'][] = esc_html__( 'Failed to load file, please try again.',  'empik-for-woocommerce' );
                $this->print_messages();
                $this->import_logistic_class('start');
                return;
            }

            $csv->symmetrize();
            return $csv->connect();
        }

        return $csv->connect();

    }
}
