<?php


namespace Inspire_Labs\Empik_Woocommerce\Wp_Admin\CSV;


class CSV_Import
{
	public function import_logistic_klass_from_csv( $product ) {
		$res = false;
		$logistic_class_data = false;

		if( isset($product['logistic-class']) ) {
			$logistic_class_data = $product['logistic-class'];
		} else if( isset($product['Logistic-class']) ) {
			$logistic_class_data = $product['Logistic-class'];
		}

		$logistic_class = '';

		if( ! $logistic_class_data ) {
			// zero in csv file
			$logistic_class = '0';
			// if in csv is just empty - we set '2' in "empik_csv_settings":206

		} else {
			$logistic_class = $logistic_class_data;
		}

		if ( ! empty( $product['ID'] ) ) {

			$current_value = get_post_meta( $product['ID'], '_empik_logistic_klass', true );
			if( (int) $current_value === (int) $logistic_class )  {
				$res = true;
			} else {
				$res = update_post_meta( $product['ID'], '_empik_logistic_klass', strval( sanitize_text_field( $logistic_class ) ) );
			}
		}

		return $res;
	}


	public function import_product_states_from_csv( $product ) {
		$res = false;
		$product_state_data = false;

		if( isset($product['state']) ) {
			$product_state_data = $product['state'];
		} else if( isset($product['State']) ) {
			$product_state_data = $product['State'];
		}

		if ( ! empty( $product['ID'] ) ) {

			if( $product_state_data ) {

				$current_value = get_post_meta($product['ID'], '_empik_product_state', true);
				if ((int)$current_value === (int)$product_state_data) {
					$res = true;
				} else {
					$product_obj = wc_get_product($product['ID']);
					if( $product_obj && !is_wp_error($product_obj)) {
						if ( $product_obj->get_type() === 'variable' ) {
							$res = update_post_meta($product['ID'], '_empik_product_state_all_variants', strval(sanitize_text_field($product_state_data)));
						} else {
							$res = update_post_meta($product['ID'], '_empik_product_state', strval(sanitize_text_field($product_state_data)));
						}
					}

				}
			}
		}

		return $res;
	}
}
