<?php

namespace Inspire_Labs\Empik_Woocommerce\Wp_Admin\CSV;

class CSV_Ajax
{
    public function __construct()
    {
        add_action('wp_ajax_empik_csv_process_emp_log_classes', array($this, 'empik_log_classes_callback'));

        add_action('wp_ajax_empik_csv_process_emp_prod_states', array($this, 'empik_prod_states_callback'));

    }

    public function empik_log_classes_callback()
    {

        if (!is_admin()) exit;

        if (!isset($_POST['events'])) {

            echo wp_json_encode(
                    array(
                        'status' => esc_html__('No rows selected', 'empik-for-woocommerce')
                    )
                );
            exit;

        } else {

            if( is_array($_POST['events']) && ! empty($_POST['events']) ) {

                $event_data = $this->recursive_sanitize_text_field($_POST['events']);

                foreach ($event_data as $scv_file_row) {

                    $processedDATA = array();
                    foreach ($scv_file_row as $MDK => $MD) {
                        $processedDATA[$MDK] = urldecode($MD);
                    }

                    $import = new CSV_Import();
                    $status = $import->import_logistic_klass_from_csv($processedDATA);
                }
            }
        }

        echo wp_json_encode(
                array(
                    'content' => '',
                    'event_id' => $status,
                    'status' => $status ? 'success' : 'bad'
                )
            );
        exit;
    }


    public function empik_prod_states_callback()
    {

        if (!is_admin()) exit;

        if (!isset($_POST['events'])) {

            echo wp_json_encode(
                    array(
                        'status' => esc_html__('No rows selected', 'empik-for-woocommerce')
                    )
                );
            exit;

        } else {

            $event_data = [];

            if( is_array($_POST['events']) && ! empty($_POST['events']) ) {

                $event_data = $this->recursive_sanitize_text_field( $_POST['events'] );

                foreach ($event_data as $scv_file_row) {

                    $processedDATA = array();
                    foreach ($scv_file_row as $MDK => $MD) {
                        $processedDATA[$MDK] = urldecode($MD);
                    }

                    $import = new CSV_Import();
                    $status = $import->import_product_states_from_csv($processedDATA);
                }
            }
        }


        echo wp_json_encode(
                array(
                    'content' => '',
                    'event_id' => $status,
                    'status' => $status ? 'success' : 'bad'
                )
            );
        exit;
    }


    /**
     * Recursive sanitation for an array
     *
     * @param $array
     *
     * @return mixed
     */
    private function recursive_sanitize_text_field($array) {
        foreach ( $array as $key => &$value ) {
            if ( is_array( $value ) ) {
                $value = $this->recursive_sanitize_text_field($value);
            }
            else {
                $value = sanitize_text_field( $value );
            }
        }

        return $array;
    }
}
