<?php

namespace Inspire_Labs\Empik_Woocommerce\Wp_Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Exception;
use Inspire_Labs\Empik_Woocommerce\Api_Client\Abstract_Api;
use Inspire_Labs\Empik_Woocommerce\Api_Client\Ajax_Response_Model;
use Inspire_Labs\Empik_Woocommerce\Api_Client\Api_Factory;
use Inspire_Labs\Empik_Woocommerce\Plugin;

abstract class Abstract_Exporter extends Abstract_Ajax {

	const EXPORTER_TYPE_PRODUCTS = 0;
	const EXPORTER_TYPE_OFFERS   = 1;

	/**
	 * @var Abstract_Api
	 */
	protected $api;

	abstract protected function do_request( string $path_to_csv ): Ajax_Response_Model;

	/**
	 * @return int
	 */
	abstract protected function get_type(): int;


	/**
	 * @return string
	 */
	abstract protected function create_csv(): string;

	/**
	 * @param Ajax_Response_Model $ajax_response_model
	 *
	 * @return mixed
	 */
	abstract protected function do_after_export_action( Ajax_Response_Model $ajax_response_model );


	public function ajax_callback() {
		$result = ( $this->export() );

		$this->do_after_export_action( $result );

		if ( $result ) {
			wp_send_json( $result->to_array(), 200 );
		}

		exit;
	}


	/**
	 * Export
	 *
	 * @return Ajax_Response_Model
	 */
	public function export(): Ajax_Response_Model {
		try {
			$api_factory = new Api_Factory();
			$this->api   = $api_factory->create_service();

			return $this->do_request( $this->create_csv() );

		} catch ( Exception $e ) {
			Plugin::write_debug_log( $e->getMessage() );

			return new Ajax_Response_Model( Ajax_Response_Model::ERROR, $e->getMessage() );
		}
	}
}
