<?php

namespace Inspire_Labs\Empik_Woocommerce\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Settings_Helper
 */
class Settings_Helper {

	/**
	 * $options
	 *
	 * @var array
	 */
	private $options;

	/**
	 * Get option
	 *
	 * @param string $key $key.
	 *
	 * @return false|mixed|void
	 */
	public function get_option( $key ) {
		return get_option( $key );
	}

	/**
	 * Is option
	 *
	 * @param string $key   $key.
	 * @param mixed  $value $value.
	 *
	 * @return bool
	 */
	public function is_option( $key, $value ): bool {
		return get_option( $key ) === $value;
	}
}
