<?php

namespace Inspire_Labs\Empik_Woocommerce\Offer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Wp_Admin\Products_List_Offers_import_Column;

/**
 * Offer_Actions
 */
class Offer_Actions {

	/**
	 * Initializes product trash handling.
	 *
	 * Sets up WordPress hook to handle product trashing events.
	 *
	 * @return void
	 */
	public function init() {
		add_action( 'wp_trash_post', array( $this, 'trash_product_action' ) );
	}

	/**
	 * Handles product trashing by updating offer status and triggering export.
	 *
	 * When a product marked for offer import is trashed, updates its delist status
	 * and triggers an offer export for this specific product.
	 *
	 * @param int $post_id The ID of the product being trashed.
	 * @return void
	 */
	public function trash_product_action( int $post_id ) {

		if ( ( new Products_List_Offers_import_Column() )->get_meta_value_true()
			=== get_post_meta(
				$post_id,
				( new Products_List_Offers_import_Column() )->get_export_offer_meta_id(),
				true
			)
		) {

			update_post_meta(
				$post_id,
				( new Products_List_Offers_import_Column() )->get_delist_offer_meta_id(),
				( new Products_List_Offers_import_Column() )->get_meta_value_true()
			);

			add_filter(
				'offer_exporter_get_products_args',
				function ( array $args ) use ( $post_id ) {
					return array(
						'post_type' => 'product',
						'p'         => $post_id,
						'fields'    => 'ids',
					);
				}
			);

			( new Offers_Exporter_Factory() )->create_service()->export();
		}
	}
}
