<?php

namespace Inspire_Labs\Empik_Woocommerce\Api_Server;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Api_Client\Ajax_Response_Model;
use Inspire_Labs\Empik_Woocommerce\Offer\Offers_Exporter_Factory;
use Inspire_Labs\Empik_Woocommerce\Order\Order_Importer;
use Inspire_Labs\Empik_Woocommerce\Order\Order_Importer_Factory;
use Inspire_Labs\Empik_Woocommerce\Plugin;
use Inspire_Labs\Empik_Woocommerce\Wp_Admin\Settings_Ids;
use WP_REST_Response;

/**
 * Ping_Import_Orders
 */
class Ping_Import_Orders extends Abstract_Api {


	/**
	 * Initializes the import orders functionality.
	 *
	 * Validates request parameters and secret token, then hooks into WordPress init
	 * to execute import callback if validation passes.
	 *
	 * @return void
	 */
	public function init() {

		if ( isset( $_GET['action'] )
			&& sanitize_text_field( $_GET['action'] ) === 'import_orders'
			&& isset( $_GET['secret'] )
			&& parent::validate_secret_token( sanitize_text_field( $_GET['secret'] ) )
		) {
			add_action(
				'init',
				function () {
					print_r( $this->callback() );
					die;
				}
			);
		}
	}


	/**
	 * Handles the orders import callback.
	 *
	 * Creates and executes orders importer service, then returns REST response
	 * with appropriate status based on import result.
	 *
	 * @return WP_REST_Response Response with status 201 and JSON body indicating success/failure.
	 */
	public function callback(): WP_REST_Response {
		$orders_importer = ( new Order_Importer_Factory() )->create_service();
		$result          = $orders_importer->import();

		$response = new WP_REST_Response(
			$result->get_status() === Ajax_Response_Model::SUCCESS
				? wp_json_encode( array( 'status' => 'OK' ) )
				: wp_json_encode( array( 'status' => 'FAILED' ) )
		);
		$response->set_status( 201 );

		return $response;
	}

	/**
	 * Generates URL for orders import endpoint.
	 *
	 * Creates a URL with import action and secret token parameters
	 * based on site home URL.
	 *
	 * @return string Complete URL for accessing the import endpoint.
	 */
	public function get_url(): string {
		$url = add_query_arg( 'action', 'import_orders', home_url() );

		return add_query_arg( 'secret', parent::get_secret_token(), $url );
	}
}
