<?php

namespace Inspire_Labs\Empik_Woocommerce\Api_Server;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Api_Client\Ajax_Response_Model;
use Inspire_Labs\Empik_Woocommerce\Product\Product_Exporter_Factory;
use WP_REST_Response;

/**
 * Ping_Export_Products
 */
class Ping_Export_Products extends Abstract_Api {


	/**
	 * Initializes the export products functionality.
	 *
	 * Validates request parameters and secret token, then hooks into WordPress init
	 * to execute export callback if validation passes.
	 *
	 * @return void
	 */
	public function init() {
		if ( isset( $_GET['action'] )
			&& sanitize_text_field( $_GET['action'] ) === 'export_products'
			&& isset( $_GET['secret'] )
			&& parent::validate_secret_token( sanitize_text_field( $_GET['secret'] ) )
		) {
			add_action(
				'init',
				function () {
					print_r( $this->callback() );
					die;
				}
			);
		}
	}

	/**
	 * Handles the products export callback.
	 *
	 * Creates and executes products exporter service, then returns REST response
	 * with appropriate status based on export result.
	 *
	 * @return WP_REST_Response Response with status 201 and JSON body indicating success/failure.
	 */
	public function callback(): WP_REST_Response {
		$products_exporter_factory = new Product_Exporter_Factory();
		$products_exporter         = $products_exporter_factory->create_service();
		// product export to API (tu się wykonuje eksport do Marketplace).
		$result = $products_exporter->export();

		$response = new WP_REST_Response(
			$result->get_status() === Ajax_Response_Model::SUCCESS
				? wp_json_encode( array( 'status' => 'OK' ) )
				: wp_json_encode( array( 'status' => 'FAILED' ) )
		);
		$response->set_status( 201 );

		return $response;
	}

	/**
	 * Generates URL for products export endpoint.
	 *
	 * Creates a URL with export action and secret token parameters
	 * based on site home URL.
	 *
	 * @return string Complete URL for accessing the export endpoint.
	 */
	public function get_url(): string {
		$url = add_query_arg(
			'action',
			'export_products',
			home_url()
		);

		return add_query_arg(
			'secret',
			parent::get_secret_token(),
			$url
		);
	}
}
