<?php

namespace Inspire_Labs\Empik_Woocommerce\Api_Server;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Api_Client\Ajax_Response_Model;
use Inspire_Labs\Empik_Woocommerce\Offer\Offers_Exporter_Factory;
use Inspire_Labs\Empik_Woocommerce\Plugin;
use Inspire_Labs\Empik_Woocommerce\Wp_Admin\Settings_Ids;
use WP_REST_Response;

/**
 * Ping_Export_Offers
 */
class Ping_Export_Offers extends Abstract_Api {

	/**
	 * Initializes the export offers functionality.
	 *
	 * Validates request parameters and secret token, then hooks into WordPress init
	 * to execute export callback if validation passes.
	 *
	 * @return void
	 */
	public function init() {

		if ( isset( $_GET['action'] )
			&& sanitize_text_field( $_GET['action'] ) === 'export_offers'
			&& isset( $_GET['secret'] )
			&& parent::validate_secret_token( sanitize_text_field( $_GET['secret'] ) )
		) {
			add_action(
				'init',
				function () {
					print_r( $this->callback() );
					die;
				}
			);
		}
	}

	/**
	 * Handles the offers export callback.
	 *
	 * Creates and executes offers exporter service, then returns REST response
	 * with appropriate status based on export result.
	 *
	 * @return WP_REST_Response Response with status 201 and JSON body indicating success/failure.
	 */
	public function callback(): WP_REST_Response {

		$offers_exporter_factory = new Offers_Exporter_Factory();
		$offers_exporter         = $offers_exporter_factory->create_service();
		// offers export to API (tu się wykonuje eksport do Marketplace).
		$result = $offers_exporter->export();

		$response = new WP_REST_Response(
			$result->get_status() === Ajax_Response_Model::SUCCESS
				? wp_json_encode( array( 'status' => 'OK' ) )
				: wp_json_encode( array( 'status' => 'FAILED' ) )
		);
		$response->set_status( 201 );

		return $response;
	}

	/**
	 * Generates URL for offers export endpoint.
	 *
	 * Creates a URL with export action and secret token parameters
	 * based on site home URL.
	 *
	 * @return string Complete URL for accessing the export endpoint.
	 */
	public function get_url(): string {
		$url = add_query_arg(
			'action',
			'export_offers',
			home_url()
		);

		return add_query_arg(
			'secret',
			parent::get_secret_token(),
			$url
		);
	}
}
