<?php

namespace Inspire_Labs\Empik_Woocommerce\Api_Client;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Ajax_Response_Model
 */
class Ajax_Response_Model {


	/**
	 * Success status constant.
	 *
	 * @var string
	 */
	const SUCCESS = 'success';

	/**
	 * Error status constant.
	 *
	 * @var string
	 */
	const ERROR = 'error';

	/**
	 * $status
	 *
	 * @var string
	 */
	private $status;

	/**
	 * $message
	 *
	 * @var string
	 */
	private $message;

	/**
	 * $data
	 *
	 * @var array
	 */
	private $data;

	/**
	 * Creates new AJAX response instance.
	 *
	 * @param string $status Response status (success/error).
	 * @param string $message Response message text.
	 * @param array  $data Optional additional response data.
	 */
	public function __construct( string $status, string $message, array $data = array() ) {
		$this->status  = $status;
		$this->message = $message;
		$this->data    = $data;
	}

	/**
	 * Gets the response status.
	 *
	 * @return string Current status value.
	 */
	public function get_status(): string {
		return $this->status;
	}

	/**
	 * Gets the response message.
	 *
	 * @return string Current message text.
	 */
	public function get_message(): string {
		return $this->message;
	}

	/**
	 * Converts response object to array.
	 *
	 * @return array Object properties as array.
	 */
	public function to_array(): array {
		return get_object_vars( $this );
	}

	/**
	 * Gets the additional response data.
	 *
	 * @return array Current data array.
	 */
	public function get_data(): array {
		return $this->data;
	}
}
